
#### Password Attacks

![[Pasted image 20250302205231.png]]

#### DNS Tunneling 

![[Pasted image 20250302205406.png]]

DNS Tunneling is a technique used by cybercriminals to covertly exfiltrate data by hiding it within DNS packets.

DNS tunneling involves encoding data within DNS queries and responses, often using methods like Base32 and Base64. Attackers exploit different DNS record types, such as **TXT records**, which can **store large amounts of data** but are less commonly requested, making them detectable.

The **tunneling** process involves **splitting data** into chunks, **embedding them in DNS** queries, and **forwarding** these queries to the **attacker's authoritative name server**, where encoded **commands are sent back to the infected host**. This method allows attackers to bypass traditional security measures.

To **combat** DNS tunneling, **organizations should monitor DNS logs** for unusual activities and implement solutions like **Cisco Umbrella** to block malicious DNS traffic.

#### Web-Based Attacks

![[Pasted image 20250302210423.png]]

![[Pasted image 20250302210455.png]]


#### HTTP 302 Cushioning 
![[Pasted image 20250302210645.png]]

#### Command Injections 

Command injection is a type of attack where an **attacker executes arbitrary commands on a web server's operating system through a vulnerable web application**. This vulnerability arises when applications accept and process unsafe input without proper validation.

#### SQL Injections 

SQL injection is a common attack method **targeting databases to exploit vulnerabilities** in web applications that interact with **SQL databases**. This attack involves **inserting malicious SQL queries** into input fields, potentially allowing attackers to read sensitive data, modify database entries, perform administrative operations, or even execute OS-level commands.

**Mutillidae** is an intentionally vulnerable web application developed purposely to present vulnerabilities to demonstrate exploitation.

#### Cross-Site Scripting and Request Forgery

**Cross-Site Scripting (XSS):**
- **Mechanism**: Involves injecting malicious scripts into trusted websites, which are then executed in the browsers of unsuspecting users. Commonly used to steal sensitive information like cookies.
- **Types**:
    - **Stored XSS**: The script is permanently stored on the server, affecting all users who visit the page.
    - **Reflected XSS**: The script is embedded in a link and executed when a user clicks it.
- **Countermeasures**:
    - Use services like Cisco Umbrella to block malicious sites.
    - Employ web proxy security solutions and IPS to detect and prevent attacks.
    - Educate users about recognizing phishing and malicious links.

**Cross-Site Request Forgery (CSRF):**
- **Mechanism**: Tricks authenticated users into executing unwanted actions on a trusted site by exploiting their browser’s credentials.
- **Example**: An attacker uses social engineering to have a victim click a link that performs actions like money transfers on a banking site.
- **Countermeasures**:
    - Educate users on phishing recognition.
    - Developers should adhere to security best practices, such as implementing anti-CSRF tokens.

#### Email - Based Attacks

 **Common Email Threats**:
    - **Attachment-Based Attacks**: Malicious content embedded in legitimate-looking files.
    - **Email Spoofing**: Forged sender addresses trick recipients into divulging sensitive information.
    - **Spam**: Overwhelms inboxes, leading to productivity loss and potential server overload.
    - **Open Mail Relays**: Misconfigured SMTP servers that allow spammers to send large volumes of email.
    - **Homoglyphs**: Similar-looking characters in URLs used in phishing to mislead users.

**Countermeasures:**

- Deploy email security solutions like Cisco Email Security Appliance (ESA) to block various email threats.
- Educate users on recognizing phishing and avoiding suspicious attachments.
- Ensure prompt patching of SMTP servers to address vulnerabilities.

